//
//  MyArc.m
//  ex_UIBezierPath_arcCenter
//
//  Created by yoshiyuki oshige on 2013/09/30.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyArc.h"

@implementation MyArc

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を透明にする
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}


- (void)drawRect:(CGRect)rect
{
    CGFloat cx = self.bounds.size.width/2;
    CGFloat cy = self.bounds.size.height/2;
    CGPoint center = CGPointMake(cx, cy);// 中心座標
    CGFloat radius = cx-20; // 半径
    CGFloat startAngle = 0.0; // 開始角度
    CGFloat endAngle = M_PI*3/2; // 終了角度
    BOOL clockwise = YES; // 時計回り
    // 円弧のパスを作る
    UIBezierPath *arcPath = [UIBezierPath bezierPathWithArcCenter:(CGPoint)center
                                                           radius:(CGFloat)radius
                                                       startAngle:(CGFloat)startAngle
                                                         endAngle:(CGFloat)endAngle
                                                        clockwise:(BOOL)clockwise];
    
    arcPath.lineWidth = 20;
    arcPath.lineCapStyle = kCGLineCapRound;
    // パスを描く
    [arcPath stroke];
}


@end
