//
//  MyCircle.m
//  ex_UIBezierPath_circle
//
//  Created by yoshiyuki oshige on 2013/09/29.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyCircle.h"

@implementation MyCircle

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を透明にする
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}

// ビューが表示される際に実行される
- (void)drawRect:(CGRect)rect
{
    // 線の幅
    CGFloat lineW = 8.0;
    // 線の色
    [[UIColor redColor] setStroke];
    // 塗り色
    [[UIColor yellowColor] setFill];

    // 領域
    CGFloat width = self.bounds.size.width - lineW;
    CGFloat height = self.bounds.size.height - lineW;
    CGRect theRect = CGRectMake(lineW/2, lineW/2, width, height);

    // 図形のパス（楕円形）
    UIBezierPath *drawPath = [UIBezierPath bezierPathWithOvalInRect:theRect];
    // 線幅
    drawPath.lineWidth = lineW;
    // パスを塗りつぶす
    [drawPath fill];
    // パスを描く
    [drawPath stroke];
}

@end
