//
//  MyFanShape.m
//  ex_UIBezierPath_closePath
//
//  Created by yoshiyuki oshige on 2013/10/01.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyFanShape.h"

@implementation MyFanShape

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を透明にする
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}

// ビューが表示される際に実行される
- (void)drawRect:(CGRect)rect
{
    CGFloat cx = self.bounds.size.width/2;
    CGFloat cy = self.bounds.size.height/2;
    CGPoint center = CGPointMake(cx, cy); // 中心座標
    CGFloat radius = cx-20; // 半径
    CGFloat startAngle = -M_PI/2; // 開始角度
    CGFloat endAngle = M_PI*4/5; // 終了角度
    BOOL clockwise = YES; // 時計回り
    // 円弧のパスを作る
    UIBezierPath *arcPath = [UIBezierPath bezierPathWithArcCenter:(CGPoint)center
                                                           radius:(CGFloat)radius
                                                       startAngle:(CGFloat)startAngle
                                                         endAngle:(CGFloat)endAngle
                                                        clockwise:(BOOL)clockwise];
    // 中心までの直線を描く
    [arcPath addLineToPoint:center];
    // 図形を閉じる
    [arcPath closePath];
    
    // パスを描く
    arcPath.lineWidth = 10;
    arcPath.lineCapStyle = kCGLineCapRound;
    [arcPath stroke];
    // 塗る
    [[UIColor cyanColor] setFill];
    [arcPath fill];
}

@end
