//
//  MyCurve.m
//  ex_UIBezierPath_curve
//
//  Created by yoshiyuki oshige on 2013/09/30.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyCurve.h"

@interface MyCurve ()
- (UIBezierPath *)makeLinePath:(CGPoint)startPoint endPoint:(CGPoint)endPoint;
@end

@implementation MyCurve

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を黄色にする
        self.backgroundColor = [UIColor yellowColor];
    }
    return self;
}


- (void)drawRect:(CGRect)rect
{
    // 上の図形の点
    CGPoint a = CGPointMake(50, 20); // 開始点
    CGPoint b = CGPointMake(150, 20); // controlPoint
    CGPoint c = CGPointMake(120, 120); // endPoint
    //　下の図形の点
    CGPoint d = CGPointMake(50, 200); // 開始点
    CGPoint e = CGPointMake(150, 200); // controlPoint1
    CGPoint f = CGPointMake(150, 300); // endPoint
    CGPoint g = CGPointMake(50, 300); // controlPoint2
    
    // 直線
    UIBezierPath *linePath = [UIBezierPath bezierPath];
    [linePath appendPath:[self makeLinePath:a endPoint:b]];
    [linePath appendPath:[self makeLinePath:b endPoint:c]];
    [linePath appendPath:[self makeLinePath:d endPoint:e]];
    [linePath appendPath:[self makeLinePath:f endPoint:g]];
    [[UIColor grayColor] setStroke];
    [linePath stroke];
    
    // 上の曲線
    UIBezierPath *curvePath1 = [UIBezierPath bezierPath];
    [curvePath1 moveToPoint:a];
    [curvePath1 addQuadCurveToPoint:c controlPoint:b];
    [[UIColor redColor] setStroke];
    curvePath1.lineWidth = 2;
    [curvePath1 stroke];
    // 下の曲線
    UIBezierPath *curvePath2 = [UIBezierPath bezierPath];
    [curvePath2 moveToPoint:d];
    [curvePath2 addCurveToPoint:f controlPoint1:e controlPoint2:g];
    [[UIColor blueColor] setStroke];
    curvePath2.lineWidth = 2;
    [curvePath2 stroke];
}

// 直線を描くパスを作る
- (UIBezierPath *)makeLinePath:(CGPoint)startPoint endPoint:(CGPoint)endPoint
{
    UIBezierPath *path = [UIBezierPath bezierPath];
    [path moveToPoint:startPoint];
    [path addLineToPoint:endPoint];
    return path;
}

@end
