//
//  MyLine.m
//  ex_UIBezierPath_line
//
//  Created by yoshiyuki oshige on 2013/09/29.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyLine.h"

@implementation MyLine

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を明るいグレイにする
        self.backgroundColor = [UIColor lightGrayColor];
    }
    return self;
}



- (void)drawRect:(CGRect)rect
{
    int ptCount = 10;
    int gap = (self.frame.size.width)/ptCount;
    int h = self.frame.size.height;
    // 結ぶ点を入れる配列
    NSMutableArray *points = [[NSMutableArray alloc]init];
    for(int i=0; i<ptCount; i++){
        CGFloat cy = arc4random()%(h-10)+5;
        // 点を作る
        CGPoint pt = CGPointMake(gap*i+5, cy);
        // 配列に入れる
        [points addObject:[NSValue valueWithCGPoint:pt]];
    }

    // 図形のパス（折れ線）
    UIBezierPath *drawPath = [UIBezierPath bezierPath];
    // 描画の開始点
    [drawPath moveToPoint:[points[0] CGPointValue]];
    for (int i=1; i<points.count; i++) {
        // 直線のパスに追加する
        [drawPath addLineToPoint:[points[i] CGPointValue]];
    }
    
    // パスを描く
    [drawPath stroke];
}


@end
