//
//  MyLine2.m
//  ex_UIBezierPath_lineStyle
//
//  Created by yoshiyuki oshige on 2013/09/30.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyLine2.h"

@implementation MyLine2

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を明るいグレイにする
        self.backgroundColor = [UIColor lightGrayColor];
    }
    return self;
}

- (void)drawRect:(CGRect)rect
{
    // 図形のパス（折れ線）
    UIBezierPath *drawPath = [UIBezierPath bezierPath];
    // 線のスタイル
    drawPath.lineWidth = 20; // 線幅
    drawPath.lineCapStyle = kCGLineCapRound; // 両端の形状
    drawPath.lineJoinStyle = kCGLineJoinBevel; // 接続箇所の形状
    
    // 描画の開始点
    [drawPath moveToPoint:CGPointMake(100,50)];
    // 線を結ぶ点
    [drawPath addLineToPoint:CGPointMake(150,100)];
    [drawPath addLineToPoint:CGPointMake(50,150)];
    [drawPath addLineToPoint:CGPointMake(110,200)];
    // パスを描く
    [drawPath stroke];
}

@end