//
//  MyRoundRect.m
//  ex_UIBezierPath_roundedRect
//
//  Created by yoshiyuki oshige on 2013/09/30.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "MyRoundRect.h"

@implementation MyRoundRect

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景色を透明にする
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}

// ビューが表示される際に実行される
- (void)drawRect:(CGRect)rect
{
    CGRect theRect = self.bounds;
    // 左上と右下の角を丸める
    UIRectCorner coners = (UIRectCornerTopLeft | UIRectCornerBottomRight);
    UIBezierPath *roundRectPath = [UIBezierPath bezierPathWithRoundedRect:theRect
                                                        byRoundingCorners:coners
                                                              cornerRadii:CGSizeMake(40, 40)];

    
    // 塗りの色
    [[UIColor redColor] setFill];
    //　塗る
    [roundRectPath fill];
}

@end
