//
//  ViewController.m
//  ex_UIImageView_animation
//
//  Created by yoshiyuki oshige on 2013/09/27.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
{
    NSArray *animationSeq;
}

//カエルのイメージビュー
@property (weak, nonatomic) IBOutlet UIImageView *frogImageView;
// カエルをタップ
- (IBAction)tapFrog:(UITapGestureRecognizer *)sender;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// パラパラアニメーションのイメージの配列
    animationSeq = @[[UIImage imageNamed:@"frog1.png"],
                     [UIImage imageNamed:@"frog2.png"],
                     [UIImage imageNamed:@"frog3.png"],
                     [UIImage imageNamed:@"frog4.png"]];
    
    // イメージの配列を設定する
    _frogImageView.animationImages = animationSeq;
    // アニメーションの秒数
    _frogImageView.animationDuration = 0.5;
    // 繰り返し回数
    _frogImageView.animationRepeatCount = 4;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

// タップでアニメーションのスタート／ストップ
- (IBAction)tapFrog:(UITapGestureRecognizer *)sender {
    if([_frogImageView isAnimating]){
        // アニメーション中なら止める
        [_frogImageView stopAnimating];
    } else {
        // 止まっていたらアニメーションをスタート
        [_frogImageView startAnimating];
    }
}

@end
