//
//  ViewController.m
//  ex_UIView_animateWithDuration
//
//  Created by yoshiyuki oshige on 2013/10/01.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// ハートのイメージビュー
@property (weak, nonatomic) IBOutlet UIImageView *heart;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void) viewDidAppear:(BOOL)animated
{
    // 座標はviewDidAppear以降でなければ取得できない
    CGFloat cx = _heart.center.x;
    CGFloat cy = _heart.center.y;
    // アニメーションのオプション
    UIViewAnimationOptions animeOptions =
        UIViewAnimationOptionCurveEaseInOut // イーズインアウト
        | UIViewAnimationOptionAutoreverse // 自動逆再生
        | UIViewAnimationOptionRepeat ; // 繰り返し
    // アニメーションの開始
    [UIView animateWithDuration:1.0 // アニメの秒数
                          delay:2.0 // 開始待ち秒数
                        options:animeOptions
                     animations:^{
                         _heart.center = CGPointMake(cx, cy+50); // 上下運動
                     }
                     completion:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
