//
//  ViewController.m
//  ex_UIView_animateWithDuration_completion
//
//  Created by yoshiyuki oshige on 2013/10/01.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// トンボのイメージビュー
@property (weak, nonatomic) IBOutlet UIImageView *tombo;
// 画面をタップする
- (IBAction)tapView:(UITapGestureRecognizer *)sender;

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// 最初はトンボを外に出しておく
    _tombo.center = [self randomPoint];
}

// タップした座標に向かって飛んでくる
- (IBAction)tapView:(UITapGestureRecognizer *)sender {
    // タップした座標を取得
    CGPoint tapPoint = [sender locationInView:self.view];
    // 進む方向にイメージビューを回転させて向ける
    CGFloat angle = atan2(tapPoint.y - _tombo.center.y, tapPoint.x - _tombo.center.x);
    _tombo.transform = CGAffineTransformMakeRotation(angle);
    
    // アニメーションのオプション
    UIViewAnimationOptions animeOptions =
    UIViewAnimationOptionBeginFromCurrentState // 現在の状態からスタート
    | UIViewAnimationOptionAllowUserInteraction // 中断を許可する
    | UIViewAnimationOptionCurveEaseOut; // イーズアウト
    
    // アニメーションの開始
    [UIView animateWithDuration:1 // アニメの秒数
                          delay:0.0 // 開始待ち秒数
                        options:animeOptions
                     animations:^{
                         _tombo.center = tapPoint; // タップした座標が最終値
                     }
                     completion:^(BOOL finished){
                         if (finished) {
                             //アニメーションが最後まで完了していたら
                             [self getOut:_tombo]; //続けるアニメーション
                         }
                     }];
}

// 画面の外へ出る
- (void) getOut:(UIImageView *)view
{
    // アニメーションのオプション
    UIViewAnimationOptions animeOptions =
    UIViewAnimationOptionBeginFromCurrentState // 現在の状態からスタート
    | UIViewAnimationOptionAllowUserInteraction // 中断を許可する
    | UIViewAnimationOptionCurveEaseIn; // イーズイン
    
    // アニメーションの開始
    [UIView animateWithDuration:0.5 // アニメの秒数
                          delay:1.0 // 開始待ち秒数
                        options:animeOptions
                     animations:^{
                         // 画面の外のポイントを作る
                         CGPoint newPt = [self randomPoint];
                         // 進む方向にイメージビューを回転させて向ける
                         CGFloat angle = atan2(newPt.y - _tombo.center.y, newPt.x - _tombo.center.x);
                         _tombo.transform = CGAffineTransformMakeRotation(angle);
                         // 移動先を設定する
                         _tombo.center =  newPt;
                     }
                     completion:nil];
}

// 画面の外のランダムなポイントを作る
- (CGPoint) randomPoint
{
    CGPoint pt;
    // 画面の高さより上下に50はみでた範囲でランダムな位置
    int hight = self.view.bounds.size.height+100;
    int y = arc4random()%hight-50;
    
    // 画面の左または右に100だけ外の座標を作る
    int isLeft = arc4random()%2;
    if(isLeft){
        pt = CGPointMake(-100.0, y);
    } else {
        pt = CGPointMake(self.view.bounds.size.width + 100.0, y);
    }
    
    return pt;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
