//
//  ViewController.m
//  ex_UIView_animateWithDuration_spring
//
//  Created by yoshiyuki oshige on 2013/10/03.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// 動く箱
@property (strong, nonatomic) IBOutlet UIView *myBox;
// ビューのタップで動作する
- (IBAction)tapView:(UITapGestureRecognizer *)sender;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

// ビューをタップした位置に箱が移動する
- (IBAction)tapView:(UITapGestureRecognizer *)sender {
    // タップしたポイント
    CGPoint tapPt = [sender locationInView:self.view];
    // ランダムなRGBカラーを作る
    CGFloat r = (arc4random()%100)/100.0;
    CGFloat g = (arc4random()%100)/100.0;
    CGFloat b = (arc4random()%100)/100.0;
    UIColor *rgba = [UIColor colorWithRed:r green:g blue:b alpha:1.0];
    
    // ランダムなframeを作る
    CGFloat w = arc4random()%100 + 50;
    CGPoint origin = CGPointMake(tapPt.x-w/2, tapPt.y-w/2);
    CGRect endFrame = CGRectMake(origin.x, origin.y, w, w);
    
    // アニメーションの設定
    [UIView animateWithDuration:1.0
                          delay:0.0
         usingSpringWithDamping:0.2 // スプリングの減衰
          initialSpringVelocity:5.0 // スプリングの初速
                        options:0
                     animations:^{
                         // タップした位置に移動、サイズの変更
                         _myBox.frame = endFrame;
                         // 色を変える
                         _myBox.backgroundColor = rgba;
                     }
                     completion:nil];
}

@end
