//
//  ViewController.m
//  ex_UIView_animateWithDuration_transform
//
//  Created by yoshiyuki oshige on 2013/10/01.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// イメージビューとアウトレット接続する
@property (strong, nonatomic) IBOutlet UIImageView *heart;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	
    // アニメーションのオプション
    UIViewAnimationOptions animeOptions =
        UIViewAnimationOptionCurveEaseInOut // イーズインアウト
        | UIViewAnimationOptionAutoreverse // 自動逆再生
        | UIViewAnimationOptionRepeat ; // 繰り返し
    
    // アニメーションの開始（拡大縮小を繰り返す）
    [UIView animateWithDuration:0.8 // アニメの秒数
                          delay:2.0 // 開始待ち秒数
                        options:animeOptions
                     animations:^{
                         // 2倍サイズになる
                         _heart.transform = CGAffineTransformMakeScale(2.0, 2.0);
                         // π/4回転する
                         _heart.transform = CGAffineTransformMakeRotation(M_PI_4);
                     }
                     completion:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
