//
//  ViewController.m
//  ex_UIView_transitionFromView
//
//  Created by yoshiyuki oshige on 2013/10/03.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
{
    NSTimer *timerObj;
    NSArray *photoNames;
    int nextNo;
}
// 写真を表示するイメージビュー
@property (weak, nonatomic) IBOutlet UIImageView *myPhoto;
@property (weak, nonatomic) IBOutlet UILabel *photoName;
// 次の写真に替える
- (void)goNextPhoto;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	
    // 切り替えるイメージの名前
    photoNames = @[@"funaya.jpg", @"kabe.jpg", @"uminoie.jpg"];
    // 最初の写真
    nextNo = 0;
    _photoName.text = photoNames[nextNo];
    
    // 切り替えに使うタイマー（3秒間隔でgoNextPhotoメソッドを繰り返し呼ぶ）
    timerObj = [NSTimer scheduledTimerWithTimeInterval:3
                                                target:self
                                              selector:@selector(goNextPhoto)
                                              userInfo:nil
                                               repeats:YES];
    
}


// タイマーで実行するメソッド
- (void)goNextPhoto
{
    // 配列の位置をカウントアップする
    if(nextNo<(photoNames.count-1)){
        nextNo++;
    }else{
        nextNo = 0;
    }
    
    // 現在のビューをfromViewにする
    UIImageView *fromView = _myPhoto;
    // 次のビューを用意する
    UIImage *nextPhoto = [UIImage imageNamed:photoNames[nextNo]];
    UIImageView *toView = [[UIImageView alloc] initWithImage:nextPhoto];
    // サイズを合わせる
    toView.frame = fromView.frame;
    
    // ビューを切り替える際のトランジションを指定する
    [UIView transitionFromView:fromView
                        toView:toView
                      duration:1.0
                       options:UIViewAnimationOptionTransitionCurlUp
                    completion:nil];
    
    // 次のビューに変更する
    _myPhoto = toView;
    _photoName.text = photoNames[nextNo];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end