//
//  ViewController.m
//  ex_UIView_transitionWithView
//
//  Created by yoshiyuki oshige on 2013/10/03.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
{
    int no;
}

// 数値をカウントアップするラベル
@property (weak, nonatomic) IBOutlet UILabel *myLabel;
// タップで実行するメソッド
- (IBAction)tapView:(UITapGestureRecognizer *)sender;

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // カウンタとラベル表示の初期化
    no = 0;
    _myLabel.text = @"0";
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

// タップで実行する
- (IBAction)tapView:(UITapGestureRecognizer *)sender {
    
    // ビューのトランジションを指定する
    [UIView transitionWithView:_myLabel
                      duration:1
                       options:UIViewAnimationOptionTransitionCrossDissolve
                    animations:^{
                        // ラベルの数字をカウントアップする
                        _myLabel.text = [NSString stringWithFormat:@"%d", ++no];
                    }
                    completion:nil];
}

@end
