//
//  ViewController.m
//  ex_UIInterpolatingMotionEffect
//
//  Created by yoshiyuki oshige on 2013/09/27.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// 木をアウトレットコレクション接続して配列に入れる
@property (strong, nonatomic) IBOutletCollection(UIImageView) NSArray *trees;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // 背景にパターンイメージを敷く
    self.view.backgroundColor = [UIColor colorWithPatternImage:[UIImage imageNamed:@"stars.png"]];
    
	// 配列treesからビューを取り出して、それぞれにモーションエフェクトを設定する
    [self ipMotionEffect:_trees[0] offset:10.0];
    [self ipMotionEffect:_trees[1] offset:50.0];
    [self ipMotionEffect:_trees[2] offset:50.0];
    [self ipMotionEffect:_trees[3] offset:90.0];
    [self ipMotionEffect:_trees[4] offset:90.0];
    [self ipMotionEffect:_trees[5] offset:90.0];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)ipMotionEffect:(UIView *)theView offset:(CGFloat)offset;
{
    // 水平方向のモーションエフェクトを作る
    UIInterpolatingMotionEffect *effectX =
        [[UIInterpolatingMotionEffect alloc]
         initWithKeyPath:@"center.x"
         type:UIInterpolatingMotionEffectTypeTiltAlongHorizontalAxis];
    // 垂直方向のモーションエフェクトを作る
    UIInterpolatingMotionEffect *effectY =
        [[UIInterpolatingMotionEffect alloc]
         initWithKeyPath:@"center.y"
         type:UIInterpolatingMotionEffectTypeTiltAlongVerticalAxis];
    
	// 水平方向の値の範囲
	effectX.maximumRelativeValue = @(offset);
	effectX.minimumRelativeValue = @(-offset);
    // 垂直方向の値の範囲
	effectY.maximumRelativeValue = @(offset);
	effectY.minimumRelativeValue = @(-offset);
    
	// ビューにモーションエフェクトを設定する
	[theView addMotionEffect:effectX];
	[theView addMotionEffect:effectY];
}

@end
