//
//  ViewController.m
//  ex_UIDA_Attachment_items
//
//  Created by yoshiyuki oshige on 2013/10/07.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// Tシャツとカエル
@property (weak, nonatomic) IBOutlet UIImageView *tshirt;
@property (weak, nonatomic) IBOutlet UIImageView *frog;

// アニメータ
@property (nonatomic, strong) UIDynamicAnimator *animator;
// 重力ビヘイビア、衝突ビヘイビア、アタッチメントビヘイビア
@property (nonatomic, strong) UIDynamicItemBehavior *itemBehavior;
@property (nonatomic, strong) UIGravityBehavior *gravityBeahvior;
@property (nonatomic, strong) UICollisionBehavior *collisionBehavior;
@property (nonatomic, strong) UIAttachmentBehavior *attachmentBehavior;

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // アニメータを作る
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    // 剛体
    NSArray *items = @[_tshirt];
    
    // アイテムビヘイビアの設定
    self.itemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.itemBehavior.density = 1.0; // 比重
    self.itemBehavior.elasticity = 0.8; // 弾性
    self.itemBehavior.friction = 0.6; // 反発
    self.itemBehavior.resistance = 0.5; // 抵抗
    
    // 重力ビヘイビアの設定
    self.gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
    // 衝突ビヘイビアの設定
    self.collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    self.collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;
    // アタッチメントビヘイビアの設定（Tシャツにカエルを貼り付ける）
    self.attachmentBehavior = [[UIAttachmentBehavior alloc]
                               initWithItem:(id<UIDynamicItem>)_frog
                               attachedToItem:(id<UIDynamicItem>)_tshirt];
    // バネでつながっているようにバウンドする
    self.attachmentBehavior.damping = 0.1;
    self.attachmentBehavior.length = 1.0;
    self.attachmentBehavior.frequency = 6;
    
    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:self.itemBehavior];
    [self.animator addBehavior:self.gravityBeahvior];
    [self.animator addBehavior:self.collisionBehavior];
    [self.animator addBehavior:self.attachmentBehavior];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
