//
//  ViewController.m
//  ex_UIDA_Gravity_Collision
//
//  Created by yoshiyuki oshige on 2013/10/05.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// アザラシ
@property (weak, nonatomic) IBOutlet UIImageView *azarashi;
// アニメータ
@property (nonatomic, strong) UIDynamicAnimator *animator;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    
    // アニメータ
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    
    // 剛体
    NSArray *items = @[_azarashi];
    
    // アイテムビヘイビアの設定
    UIDynamicItemBehavior *itemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    itemBehavior.density = 1.0; // 比重
    itemBehavior.elasticity = 0.6; // 弾性
    itemBehavior.friction = 0.3; // 反発
    itemBehavior.resistance = 0.5; // 抵抗
    
    // 重力ビヘイビアの設定
    UIGravityBehavior *gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
  
    // 衝突ビヘイビアの設定
    UICollisionBehavior *collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;

    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:itemBehavior];
    [self.animator addBehavior:gravityBeahvior];
    [self.animator addBehavior:collisionBehavior];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

@end
