//
//  ViewController.m
//  ex_UIDA_Gravity_Collision_ItemBehavior
//
//  Created by yoshiyuki oshige on 2013/10/05.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
// ビューをタップ
- (IBAction)tappedView:(UITapGestureRecognizer *)sender;
// アニメータ
@property (nonatomic, strong) UIDynamicAnimator *animator;
// アイテムビヘイビア、重力ビヘイビア、衝突ビヘイビア
@property (nonatomic, strong) UIDynamicItemBehavior *azarashiItemBehavior;
@property (nonatomic, strong) UIDynamicItemBehavior *frogItemBehavior;
@property (nonatomic, strong) UIGravityBehavior *gravityBeahvior;
@property (nonatomic, strong) UICollisionBehavior *collisionBehavior;

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    // アニメータを作る
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    
    // 剛体
    NSArray *items = nil;
    
    // アザラシ用のアイテムビヘイビア
    self.azarashiItemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.azarashiItemBehavior.density = 1.0; // 比重
    self.azarashiItemBehavior.elasticity = 0.6; // 弾性
    self.azarashiItemBehavior.friction = 0.3; // 反発
    self.azarashiItemBehavior.resistance = 0.5; // 抵抗
    // カエル用のアイテムビヘイビア
    self.frogItemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.frogItemBehavior.density = 0.5; // 比重
    self.frogItemBehavior.elasticity = 1.0; // 弾性
    self.frogItemBehavior.friction = 0.5; // 反発
    self.frogItemBehavior.resistance = 0.2; // 抵抗
    
    // 重力ビヘイビアの設定
    self.gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
    // 衝突ビヘイビアの設定
    self.collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    self.collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;

    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:self.azarashiItemBehavior];
    [self.animator addBehavior:self.frogItemBehavior];
    [self.animator addBehavior:self.gravityBeahvior];
    [self.animator addBehavior:self.collisionBehavior];
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)tappedView:(UITapGestureRecognizer *)sender {
    // イメージビューをランダムに作る
    NSArray *imageNames = @[@"azarashi.png", @"frog.png"];
    NSUInteger num = arc4random() % imageNames.count;
    NSString *imageName = imageNames[num];
    UIImage *image = [UIImage imageNamed:imageName];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    // タップした位置に表示する
    imageView.center = [sender locationInView:self.view];
    [self.view addSubview:imageView];
    
    // 該当するアイテムビヘイビアに追加する
    if ([imageName isEqualToString:@"azarashi.png"]) {
        [self.azarashiItemBehavior addItem:imageView];
    } else if([imageName isEqualToString:@"frog.png"]){
        [self.frogItemBehavior addItem:imageView];
    }
    
    // 重力ビヘイビアと衝突ビヘイビアにも追加する
    [self.gravityBeahvior addItem:imageView];
    [self.collisionBehavior addItem:imageView];
}
@end
