//
//  ViewController.m
//  ex_UIDA_Gravity_Collision_Push
//
//  Created by yoshiyuki oshige on 2013/10/06.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()
{
    NSTimer *timerObj;
}
// アニメータ
@property (nonatomic, strong) UIDynamicAnimator *animator;
// アイテムビヘイビア、重力ビヘイビア、衝突ビヘイビア、プッシュビヘイビア
@property (nonatomic, strong) UIDynamicItemBehavior *itemBehavior;
@property (nonatomic, strong) UIGravityBehavior *gravityBeahvior;
@property (nonatomic, strong) UICollisionBehavior *collisionBehavior;
@property (nonatomic, strong) UIPushBehavior *pushBehavior;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// 剛体
    NSArray *items = nil;
    // アイテムビヘイビアの設定
    self.itemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.itemBehavior.density = 1.0; // 比重
    self.itemBehavior.elasticity = 0.3; // 弾性
    self.itemBehavior.friction = 0.5; // 反発
    self.itemBehavior.resistance = 0.8; // 抵抗
    // 重力ビヘイビアの設定
    self.gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
    // 衝突ビヘイビアの設定
    self.collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    self.collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;
    // プッシュビヘイビアの作成
    self.pushBehavior = [[UIPushBehavior alloc] initWithItems:nil mode:UIPushBehaviorModeInstantaneous];
    
    // アニメータを作る
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:self.itemBehavior];
    [self.animator addBehavior:self.gravityBeahvior];
    [self.animator addBehavior:self.collisionBehavior];
    [self.animator addBehavior:self.pushBehavior];
    
    // カエルを追加するタイマー
    timerObj = [NSTimer scheduledTimerWithTimeInterval:1.5
                                                target:self
                                              selector:@selector(addFrog)
                                              userInfo:nil
                                               repeats:YES];

}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)addFrog
{
    // カエルを作ってビューに追加する
    UIImage *image = [UIImage imageNamed:@"frog.png"];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    CGFloat y = self.view.frame.size.height;
    imageView.center = CGPointMake(50, y-100);
    [self.view addSubview:imageView];

    // プッシュビヘイビアにアイテムが入っていたら取り除き、activeにする
    if(self.pushBehavior.items.count >0){
        [self.pushBehavior removeItem:self.pushBehavior.items[0]];// 空にする
        self.pushBehavior.active = YES;// 再び１度だけ押すように初期化する
    }
    // プッシュする角度と強さを設定する
    self.pushBehavior.angle = -M_PI/4;
    self.pushBehavior.magnitude = 1+arc4random()%10*0.1;
    
    // カエルをビヘイビアに追加する
    [self.itemBehavior addItem:imageView];
    [self.gravityBeahvior addItem:imageView];
    [self.collisionBehavior addItem:imageView];
    [self.pushBehavior addItem:imageView];
    
    // カエルが10匹を超えたらタイマーを止める
    if(self.itemBehavior.items.count >= (10))
    {
        [timerObj invalidate];
    }
}

@end
