//
//  ViewController.m
//  ex_UIDA_Gravity_Collision_bezierPath
//
//  Created by yoshiyuki oshige on 2013/10/05.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"
#import "DrawBezierPath.h"

@interface ViewController ()
{
    NSTimer *timerObj;
}
// アニメータ、重力ビヘイビア、衝突ビヘイビア
@property (nonatomic, strong) UIDynamicAnimator *animator;
@property (nonatomic, strong) UIDynamicItemBehavior *itemBehavior;
@property (nonatomic, strong) UIGravityBehavior *gravityBeahvior;
@property (nonatomic, strong) UICollisionBehavior *collisionBehavior;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // ベジェ曲線を結ぶ点とコントロールポイントの座標
    CGPoint startPoint = CGPointMake(55, 250);
    CGPoint endPoint = CGPointMake(260, 310);
    CGPoint controlPt = CGPointMake(130, 130);
    
    // ベジェ曲線のパスを作る
    UIBezierPath *bezierPath = [UIBezierPath bezierPath];
   [bezierPath moveToPoint:startPoint];
   [bezierPath addQuadCurveToPoint:endPoint controlPoint:controlPt];
    
    // ベジェ曲線を描いて表示する
    CGRect frame =  self.view.frame;
    DrawBezierPath *curve = [[DrawBezierPath alloc] initWithFrame:frame bezierPath:bezierPath];
    [self.view addSubview:curve];
    
    // 剛体
    NSArray *items = nil;
    // アイテムビヘイビアの設定
    self.itemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.itemBehavior.density = 1.0; // 比重
    self.itemBehavior.elasticity = 0.2; // 弾性
    self.itemBehavior.friction = 0.2; // 反発
    self.itemBehavior.resistance = 0.8; // 抵抗
    // 重力ビヘイビアの設定
    self.gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
    // 衝突ビヘイビアの設定
    self.collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    self.collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;
    // ベジェ曲線の壁を追加する
    [self.collisionBehavior addBoundaryWithIdentifier:(id<NSCopying>)@"curve" forPath:bezierPath];
 
    // アニメータを作る
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:self.itemBehavior];
    [self.animator addBehavior:self.gravityBeahvior];
    [self.animator addBehavior:self.collisionBehavior];
    
    // カエルを追加するタイマー
    timerObj = [NSTimer scheduledTimerWithTimeInterval:1.0
                                                target:self
                                              selector:@selector(addFrog)
                                              userInfo:nil
                                               repeats:YES];
}


- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)addFrog
{
    // カエルを作ってビューに追加する
    UIImage *image = [UIImage imageNamed:@"frog.png"];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    CGFloat x = arc4random()%70 + 80.0;
    imageView.center = CGPointMake(x, 20.0);
    [self.view addSubview:imageView];
    
    // カエルをビヘイビアに追加する
    [self.itemBehavior addItem:imageView];
    [self.gravityBeahvior addItem:imageView];
    [self.collisionBehavior addItem:imageView];
    
    // カエルが10匹を超えたらタイマーを止める
    if(self.itemBehavior.items.count >= (10))
    {
        [timerObj invalidate];
    }
}

@end
