//
//  DrawLine.m
//  ex_UIDA_Gravity_Collision_lineBound
//
//  Created by yoshiyuki oshige on 2013/10/05.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "DrawLine.h"

@interface DrawLine ()
@property CGPoint startPoint;
@property CGPoint endPoint;
@end

@implementation DrawLine

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
    }
    return self;
}

// カスタムイニシャライザ
- (id)initWithFrame:(CGRect)frame startPoint:(CGPoint)startPoint endPoint:(CGPoint)endPoint
{
    self = [super initWithFrame:frame];
    if (self) {
        // 背景が透けるようにする
        self.backgroundColor = [UIColor clearColor];
        self.startPoint = startPoint;
        self.endPoint = endPoint;
    }
    return self;
}

// 描画する
- (void)drawRect:(CGRect)rect
{
    UIBezierPath *drawPath = [UIBezierPath bezierPath];
    // 描画の開始点と終了点
    [drawPath moveToPoint:self.startPoint];
    [drawPath addLineToPoint:self.endPoint];
    // パスを描く
    [drawPath stroke];
}

@end
