//
//  ViewController.m
//  ex_UIDA_Gravity_Collision_lineBound
//
//  Created by yoshiyuki oshige on 2013/10/05.
//  Copyright (c) 2013年 yoshiyuki. All rights reserved.
//

#import "ViewController.h"
#import "DrawLine.h"

@interface ViewController ()
{
    NSTimer *timerObj;
}
// アニメータ、重力ビヘイビア、衝突ビヘイビア
@property (nonatomic, strong) UIDynamicAnimator *animator;
@property (nonatomic, strong) UIDynamicItemBehavior *itemBehavior;
@property (nonatomic, strong) UIGravityBehavior *gravityBeahvior;
@property (nonatomic, strong) UICollisionBehavior *collisionBehavior;
@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// 線を結ぶ点の座標
    CGPoint pt1 = CGPointMake(270, 100);
    CGPoint pt2 = CGPointMake(160, 200);
    CGPoint pt3 = CGPointMake(60, 230);
    CGPoint pt4 = CGPointMake(200, 350);
    
    // 直線を描いて表示する
    CGRect frame =  self.view.frame;
    DrawLine *line1 = [[DrawLine alloc] initWithFrame:frame startPoint:pt1 endPoint:pt2];
    DrawLine *line2 = [[DrawLine alloc] initWithFrame:frame startPoint:pt3 endPoint:pt4];
    [self.view addSubview:line1];
    [self.view addSubview:line2];

    // 剛体
    NSArray *items = nil;
    // アイテムビヘイビアの設定
    self.itemBehavior = [[UIDynamicItemBehavior alloc] initWithItems:items];
    self.itemBehavior.density = 0.5; // 比重
    self.itemBehavior.elasticity = 1.0; // 弾性
    self.itemBehavior.friction = 0.5; // 反発
    self.itemBehavior.resistance = 0.2; // 抵抗
    // 重力ビヘイビアの設定
    self.gravityBeahvior = [[UIGravityBehavior alloc] initWithItems:items];
    // 衝突ビヘイビアの設定
    self.collisionBehavior = [[UICollisionBehavior alloc] initWithItems:items];
    self.collisionBehavior.translatesReferenceBoundsIntoBoundary = YES;
    // 直線の壁を追加する
    [self.collisionBehavior addBoundaryWithIdentifier:(id<NSCopying>)@"line1" fromPoint:(CGPoint)pt1 toPoint:(CGPoint)pt2];
    [self.collisionBehavior addBoundaryWithIdentifier:(id<NSCopying>)@"line2" fromPoint:(CGPoint)pt3 toPoint:(CGPoint)pt4];
    
    // アニメータを作る
    self.animator = [[UIDynamicAnimator alloc] initWithReferenceView:self.view];
    // アニメータにビヘイビアを登録する
    [self.animator addBehavior:self.itemBehavior];
    [self.animator addBehavior:self.gravityBeahvior];
    [self.animator addBehavior:self.collisionBehavior];
    
    // カエルを追加するタイマー
    timerObj = [NSTimer scheduledTimerWithTimeInterval:1.0
                                                target:self
                                              selector:@selector(addFrog)
                                              userInfo:nil
                                               repeats:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)addFrog
{
    // カエルを作ってビューに追加する
    UIImage *image = [UIImage imageNamed:@"frog.png"];
    UIImageView *imageView = [[UIImageView alloc] initWithImage:image];
    imageView.center = CGPointMake(250, 20);
    [self.view addSubview:imageView];
    
    // カエルをビヘイビアに追加する
    [self.itemBehavior addItem:imageView];
    [self.gravityBeahvior addItem:imageView];
    [self.collisionBehavior addItem:imageView];
    
    // カエルが10匹を超えたらタイマーを止める
    if(self.itemBehavior.items.count >= (10))
    {
        [timerObj invalidate];
    }
}

@end
