//
//  ViewController.swift
//  uiButton_layer
//
//  Created by yoshiyuki oshige on 2015/08/28.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    func hello(sender:UIButton) {
        print("ハロー")
    }

    // ボタンを作って表示する
    func addButton() {
        let myButton = UIButton(frame: CGRectMake(0,0,120,50))
        // 赤い角丸四角形を描く
        myButton.layer.masksToBounds = true
        myButton.layer.cornerRadius = 20.0
        myButton.backgroundColor = UIColor.redColor()
        myButton.setTitle("ハロー", forState: .Normal)
        // 画面の下の中央に表示する
        myButton.layer.position = CGPoint(x: view.bounds.width/2, y:view.bounds.height-50)
        // タップでhello()を実行する
        myButton.addTarget(self, action: Selector("hello:"), forControlEvents: .TouchUpInside)
        
        // ボタンをViewに追加する
        view.addSubview(myButton)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ボタンを作る
        addButton()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

