//
//  ViewController.swift
//  uiButton_setBackgroundImage
//
//  Created by yoshiyuki oshige on 2015/08/29.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    // ボタンで実行するメソッド
    func ok(sender:UIButton) {
        print("OK")
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // ボタンを作る
        let okButton = UIButton()
        // 領域
        okButton.frame = CGRect(x: 100, y: 100, width: 120, height: 120)
        // 背景画像
        let bkgImage = UIImage(named: "maru")
        okButton.setBackgroundImage(bkgImage, forState: .Normal)
        // タイトル
        okButton.setTitle("OK", forState: .Normal)
        okButton.setTitleColor(UIColor.blackColor(), forState: .Normal)
        // ボタンで実行するメソッド
        okButton.addTarget(self, action: Selector("ok:"), forControlEvents: UIControlEvents.TouchUpInside)
        // ビューに追加する
        view.addSubview(okButton)
        
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

