//
//  ViewController.swift
//  uiTextField_delegate
//
//  Created by yoshiyuki oshige on 2015/08/31.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITextFieldDelegate {

    // テキストフィールドのプロパティ宣言
    @IBOutlet weak var myTextField: UITextField!
    // ラベルのプロパティ宣言
    @IBOutlet weak var myLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // myTextFieldのデリゲートになる
        myTextField.delegate = self
        
    }
    
    func textField(textField: UITextField, shouldChangeCharactersInRange range: NSRange, replacementString string: String) -> Bool {
        
        // 変更後の内容を作成する
        var tmpStr = textField.text! as NSString
        tmpStr = tmpStr.stringByReplacingCharactersInRange(range, withString: string)
        
        if tmpStr == "" {
            // 変更後が空ならばラベルに 0 を表示する
            myLabel.text = "0"
        } else {
            // 変更後の値を計算してラベルに表示する（25を掛けた値）
            let num = Int(tmpStr as String)
            myLabel.text = String(num! * 25)
            
        }
        // テキストフィールドを更新する
        return true
        
    }
    
    // クリアボタンで実行されるtextFieldShouldClear()デリゲートメソッド
    func textFieldShouldClear(textField: UITextField) -> Bool {
        myLabel.text = "0"
        return true
    }
    
    // 画面タップでキーボードを下げる
    @IBAction func tapView(sender: UITapGestureRecognizer) {
        // 編集終了でキーボードを下げる
        self.view.endEditing(true)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

