//
//  ViewController.swift
//  view_clipsToBounds
//
//  Created by yoshiyuki oshige on 2015/09/04.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()

        // myViewを作る
        let myView = UIView(frame: CGRectMake(0, 0, 100, 100))
        myView.backgroundColor = UIColor.redColor()
        
        // イメージビューを作る
        let imageView = UIImageView(frame: CGRectMake(0, 0, 100, 100))
        imageView.image = UIImage(named: "flower")
        // 画像を縮小して全体を表示する
        imageView.contentMode = UIViewContentMode.ScaleAspectFit
        // myViewの中での座標
        imageView.center = CGPointMake(80, 80)
        
        // myViewのサブビューにする
        myView.addSubview(imageView)
        // サブビューをクリップして表示する
        myView.clipsToBounds = true
        
        // myViewを画面に表示する
        myView.center = CGPointMake(100, 100)
        view.addSubview(myView)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

