//
//  ViewController.swift
//  ex_constraintWithItem
//
//  Created by yoshiyuki oshige on 2015/09/06.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ルートビューの背景色をグレーにする
        self.view.backgroundColor = UIColor.lightGrayColor()
        // イメージビューを作る
        let photoImage = UIImage(named: "IMG_4048.jpg")
        let imageView = UIImageView(image: photoImage)
        // イメージの表示モード
        imageView.contentMode = UIViewContentMode.ScaleToFill
        // イメージビューを自動でサイズ調整しない
        imageView.translatesAutoresizingMaskIntoConstraints = false
        //　Constraintsを設定する前にイメージビューをルートビューに追加する
        self.view.addSubview(imageView)
        
        /* Constraintsの作成と設定 */
        // 上辺からの距離
        let constraintTop = NSLayoutConstraint(
            item: imageView,
            attribute: NSLayoutAttribute.Top,
            relatedBy: NSLayoutRelation.Equal,
            toItem: self.view,
            attribute: NSLayoutAttribute.Top,
            multiplier: 1,
            constant: 60)
        // 右辺からの距離
        let constraintRight = NSLayoutConstraint(
            item: imageView,
            attribute: NSLayoutAttribute.Right,
            relatedBy: NSLayoutRelation.Equal,
            toItem: self.view,
            attribute: NSLayoutAttribute.Right,
            multiplier: 1,
            constant: -30)
        // イメージビューの幅
        let constraintWidth = NSLayoutConstraint(
            item: imageView,
            attribute: NSLayoutAttribute.Width,
            relatedBy: NSLayoutRelation.Equal,
            toItem: nil,
            attribute: NSLayoutAttribute.NotAnAttribute,
            multiplier: 1,
            constant: 214)
        // イメージビューの高さ
        let constraintHeight = NSLayoutConstraint(
            item: imageView,
            attribute: NSLayoutAttribute.Height,
            relatedBy: NSLayoutRelation.Equal,
            toItem: nil,
            attribute: NSLayoutAttribute.NotAnAttribute,
            multiplier: 1,
            constant: 160)
        
        // ビューにConstraintsを設定する
        self.view.addConstraint(constraintTop)
        self.view.addConstraint(constraintRight)
        self.view.addConstraint(constraintWidth)
        self.view.addConstraint(constraintHeight)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
}
