//
//  ViewController.swift
//  ex_constraintsWithVisualFormat
//
//  Created by yoshiyuki oshige on 2015/09/06.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ルートビューの背景色をグレーにする
        self.view.backgroundColor = UIColor.lightGrayColor()
        // イメージビューを作る
        let photoImage = UIImage(named: "IMG_4048.jpg")
        let imageView = UIImageView(image: photoImage)
        //imageView.backgroundColor = UIColor.darkGrayColor()
        
        // イメージの表示モード
        imageView.contentMode = UIViewContentMode.ScaleAspectFit
        // イメージビューを自動でサイズ調整しない
        imageView.translatesAutoresizingMaskIntoConstraints = false
        //　constraintを設定する前にイメージビューをルートビューに追加する
        self.view.addSubview(imageView)
        
        // 左右の辺からの間隔を50にする
        let constraintH = NSLayoutConstraint.constraintsWithVisualFormat(
            "H:|-50-[imageView]-50-|",
            options: NSLayoutFormatOptions(rawValue: 0),
            metrics: nil,
            views: ["imageView":imageView])
        
        // 上下の辺から間隔を50にする
        let constraintV = NSLayoutConstraint.constraintsWithVisualFormat(
            "V:|-50-[imageView]-50-|",
            options: NSLayoutFormatOptions(rawValue: 0),
            metrics: nil,
            views: ["imageView":imageView])
        
        //ビューにconstraintを設定する
        // constraintH、constraintVは配列なのでaddConstraintsを使う
        self.view.addConstraints(constraintH+constraintV)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}

