//
//  ViewController.swift
//  ex_constraintsWithVisualFormat_button
//
//  Created by yoshiyuki oshige on 2015/09/06.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // ボタンで使う色
        let titleColor = UIColor.blackColor()
        let touchColor = UIColor.yellowColor()
        let bkgColor = UIColor.lightGrayColor()
        // button1を作る
        let button1 = UIButton()
        button1.setTitle("Button 1", forState: UIControlState.Normal)
        button1.setTitleColor(titleColor, forState: UIControlState.Normal)
        button1.setTitleColor(touchColor, forState: UIControlState.Highlighted)
        button1.titleLabel?.font = UIFont.systemFontOfSize(15)
        button1.backgroundColor = bkgColor
        // button2を作る
        let button2 = UIButton()
        button2.setTitle("Button 2", forState: UIControlState.Normal)
        button2.setTitleColor(titleColor, forState: UIControlState.Normal)
        button2.setTitleColor(touchColor, forState: UIControlState.Highlighted)
        button2.titleLabel?.font = UIFont.systemFontOfSize(15)
        button2.backgroundColor = bkgColor
        // ボタンを自動でサイズ調整しない
        button1.translatesAutoresizingMaskIntoConstraints = false
        button2.translatesAutoresizingMaskIntoConstraints = false
        // ボタンをビューに追加する
        self.view.addSubview(button1)
        self.view.addSubview(button2)
        
        /* Constraintsの作成と設定 */
        // Constraintsで制限するボタン
        var buttons:[String:UIButton] = [:]
        buttons["button1"] = button1
        buttons["button2"] = button2
        
        // 幅80、button1とbutton2の間隔10、右辺から30
        let constraintH = NSLayoutConstraint.constraintsWithVisualFormat(
            "H:[button1(==80)]-10-[button2(==80)]-30-|",
            options: NSLayoutFormatOptions(rawValue: 0),
            metrics: nil,
            views: buttons)
        
        // button1の高さ25、下辺から30
        let constraintV1 = NSLayoutConstraint.constraintsWithVisualFormat(
            "V:[button1(==25)]-30-|",
            options: NSLayoutFormatOptions(rawValue: 0),
            metrics: nil,
            views: buttons)
        
        // button2の高さ25、下辺から30
        let constraintV2 = NSLayoutConstraint.constraintsWithVisualFormat(
            "V:[button2(==25)]-30-|",
            options: NSLayoutFormatOptions(rawValue: 0),
            metrics: nil,
            views: buttons)
        
        
        // ビューにconstraintを設定する
        self.view.addConstraints(constraintH + constraintV1 + constraintV2)
        
        // ボタンタップで実行するメソッドを設定する
        button1.addTarget(self,action:Selector("hello:"),
            forControlEvents: UIControlEvents.TouchUpInside)
        button2.addTarget(self,action:Selector("thanks:"),
            forControlEvents: UIControlEvents.TouchUpInside)
    }
    
    // ボタンで実行するメソッド
    func hello(sender:UIButton) {
        print("ハロー")
    }
    func thanks(sender:UIButton) {
        print(sender.currentTitle!)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}