//
//  ViewController.swift
//  uiStackView_arrangedSubviews
//
//  Created by yoshiyuki oshige on 2015/09/07.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        
        // スタックビューに入れるビューを準備する
        let view1 = UIView()
        view1.backgroundColor = .lightGrayColor()
        let view2 = UIView()
        view2.backgroundColor = .grayColor()
        // 写真のイメージビュー
        let photo1 = UIImageView(image: UIImage(named: "sozai/IMG_4048.jpg"))
        let photo2 = UIImageView(image: UIImage(named: "sozai/IMG_4202.jpg"))
        let photo3 = UIImageView(image: UIImage(named: "sozai/IMG_4854.jpg"))
        photo1.contentMode = .ScaleAspectFill
        photo1.clipsToBounds = true
        photo2.contentMode = .ScaleAspectFill
        photo2.clipsToBounds = true
        photo3.contentMode = .ScaleAspectFill
        photo3.clipsToBounds = true
        
        // スタックビューを作る
        let stackView = UIStackView(frame: CGRectMake(0, 0, 300, 600))
        stackView.axis = .Vertical
        stackView.distribution = .FillEqually
        stackView.spacing = 10
        
        // スタックビューに用意しておいたビューを追加する
        stackView.addArrangedSubview(view1)
        stackView.addArrangedSubview(view2)
        stackView.addArrangedSubview(photo1)
        stackView.addArrangedSubview(photo2)
        stackView.addArrangedSubview(photo3)
        
        // スタックビューを画面中央に表示する
        stackView.center = self.view.center
        self.view.addSubview(stackView)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

}

