//
//  ViewController.swift
//  ex_tableView
//
//  Created by yoshiyuki oshige on 2015/09/07.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
       
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // テーブルビューを作る
        let myTableView = UITableView(frame: view.frame, style: .Grouped)
        // テーブルビューのデリゲートを設定する
        myTableView.delegate = self
        // テーブルビューのデータソースを設定する
        myTableView.dataSource = self
        // テーブルビューを表示する
        view.addSubview(myTableView)
    }
    
    /*　UITableViewDataSourceプロトコル */
    // セクションの個数を決める
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 3
    }
    
    // セクション内の行数を決める
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0 {
            return 3
        } else {
            return 5
        }
    }
    
    // セクションのタイトルを決める
    func tableView(tableView: UITableView, titleForHeaderInSection section: Int) -> String? {
        return "セクション" + String(section)
    }
    
    // セルを作る
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = UITableViewCell(style: .Subtitle, reuseIdentifier: "cell")
        cell.textLabel?.text = "セル" + String(indexPath.row)
        cell.detailTextLabel?.text = "サブタイトル"
        return cell
    }
    

    /* UITableViewDelegateデリゲートメソッド */
    // 行がタップされると実行される
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        print("セクション\(indexPath.section)")
        print("セル\(indexPath.row)")
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

