//
//  ViewController.swift
//  navigationController_weblist
//
//  Created by yoshiyuki oshige on 2015/09/09.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    @IBOutlet weak var webView: UIWebView!
    
    // シーン移動の際に設定されるWebデータ
    var data:(name:String, url:String)?
    
    // Webページを開く
    func openWeb() {
        // dataが設定されていればwebDataに入れる
        if let webData = data {
            // アクセスするURLを作る
            if let url = NSURL(string:webData.url) {
                let urlReq = NSURLRequest(URL: url)
                // Webページを開く
                webView.loadRequest(urlReq)
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Webページを開く
        openWeb()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}

