//
//  WebListTableViewController.swift
//  navigationController_weblist
//
//  Created by yoshiyuki oshige on 2015/09/09.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class WebListTableViewController: UITableViewController {
    
    // セルに表示するデータ
    let webList = [
        (name:"アップル", url:"http://www.apple.com/jp/"),
        (name:"国立天文台", url:"http://www.nao.ac.jp"),
        (name:"東京都美術館", url:"http://www.tobikan.jp"),
        (name:"amazon", url:"http://www.amazon.co.jp")
    ]
    
    // MARK: - Table view data source
    
    // セクションの個数
    override func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1
    }
    
    // セクション内の行数
    override func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        // 配列webListの値の個数
        return webList.count
    }
    
    // セルを作る
    override func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        // テーブルのセルを参照する
        let cell = tableView.dequeueReusableCellWithIdentifier("Cell", forIndexPath: indexPath)
        // テーブルにWebListのデータを表示する
        let webData = webList[indexPath.row]
        cell.textLabel?.text = webData.name
        cell.detailTextLabel?.text = webData.url
        
        return cell
    }
    
    // MARK: - Navigation
    
    // セグエで移動する前にデータを受け渡す
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // セグエがshowWebPageのときの処理
        if segue.identifier == "showWebPage" {
            // セグエshowWebPageのときに実行する
            if let indexPath = self.tableView.indexPathForSelectedRow {
                // 行のデータを取り出す
                let webData = webList[indexPath.row]
                // 移動先のビューコントローラのdataプロパティに値を設定する
                (segue.destinationViewController as! ViewController).data = webData
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Uncomment the following line to preserve selection between presentations
        // self.clearsSelectionOnViewWillAppear = false
        
        // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
        // self.navigationItem.rightBarButtonItem = self.editButtonItem()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
    /*
    // Override to support conditional editing of the table view.
    override func tableView(tableView: UITableView, canEditRowAtIndexPath indexPath: NSIndexPath) -> Bool {
    // Return false if you do not want the specified item to be editable.
    return true
    }
    */
    
    /*
    // Override to support editing the table view.
    override func tableView(tableView: UITableView, commitEditingStyle editingStyle: UITableViewCellEditingStyle, forRowAtIndexPath indexPath: NSIndexPath) {
    if editingStyle == .Delete {
    // Delete the row from the data source
    tableView.deleteRowsAtIndexPaths([indexPath], withRowAnimation: .Fade)
    } else if editingStyle == .Insert {
    // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }
    }
    */
    
    /*
    // Override to support rearranging the table view.
    override func tableView(tableView: UITableView, moveRowAtIndexPath fromIndexPath: NSIndexPath, toIndexPath: NSIndexPath) {
    
    }
    */
    
    /*
    // Override to support conditional rearranging of the table view.
    override func tableView(tableView: UITableView, canMoveRowAtIndexPath indexPath: NSIndexPath) -> Bool {
    // Return NO if you do not want the item to be re-orderable.
    return true
    }
    */
    
}

