//
//  ViewController.swift
//  uiAlertController_alert
//
//  Created by yoshiyuki oshige on 2015/09/10.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    @IBAction func showAlert(sender: AnyObject) {
        // アラートを作る
        let alert = UIAlertController(title: nil, message: nil, preferredStyle: .Alert)
        alert.title = "タイトル"
        alert.message = "メッセージ文"
        
        // ボタン1
        alert.addAction(
            UIAlertAction(
            title: "ボタン１です",
            style: UIAlertActionStyle.Default,
            handler: {(action) -> Void in
                self.hello(action.title!)
            })
        )
        
        // ボタン２
        alert.addAction(
                UIAlertAction(
                title: "ボタン２です",
                style: UIAlertActionStyle.Default,
                handler: {(action) -> Void  in
                    self.hello(action.title!)
                })
        )
        
        // キャンセル（追加順にかかわらず最後に表示される）
        alert.addAction(
                UIAlertAction(
                title: "キャンセル",
                style: UIAlertActionStyle.Cancel,
                handler: nil)
        )
        
        
        // 赤色のボタン
        alert.addAction(
            UIAlertAction(
            title: "削除します",
            style: UIAlertActionStyle.Destructive,
            handler: {(action) -> Void in
                self.hello(action.title!)
            })
        )
        
        // アラートを表示する
        self.presentViewController(
            alert,
            animated: true,
            completion: {
                // 表示完了後に実行
                print("アラートが表示された")
            }
        )
    }
    
    func hello(msg:String) {
        print(msg)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

