//
//  ViewController.swift
//  uiAlertController_alert_textfield
//
//  Created by yoshiyuki oshige on 2015/09/10.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITextFieldDelegate {
    @IBAction func showAlert(sender: AnyObject) {
        // アラートを作る
        let alert = UIAlertController(title: nil, message: nil, preferredStyle: .Alert)
        alert.title = "タイトル"
        alert.message = "メッセージ文"
        
        // テキストフィールド
        alert.addTextFieldWithConfigurationHandler{(textField) -> Void  in
            // テキストフィールドのデリゲートになる
            textField.delegate = self
        }
        
        // OKボタン
        alert.addAction(
            UIAlertAction(
            title: "OK",
            style: UIAlertActionStyle.Default,
            handler: {(action) -> Void in
            self.hello(action.title!)
            })
        )

        // キャンセル
        alert.addAction(
            UIAlertAction(
            title: "キャンセル",
            style: UIAlertActionStyle.Cancel,
            handler: nil)
        )
        
        // アラートを表示する
        self.presentViewController(
                alert,
                animated: true,
                completion: {
                    // 表示完了後に実行
                    print("アラートが表示された")
                }
        )
    }
    
    // テキストフィールドの編集終了（キーボードを下げる）
    func textFieldDidEndEditing(textField: UITextField) {
            print(textField.text)
    }
    
    func hello(msg:String) {
            print(msg)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

