//
//  ViewController.swift
//  animation_easeInOut
//
//  Created by yoshiyuki oshige on 2015/09/11.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    // アザラシ
    @IBOutlet weak var azarashi: UIImageView!
    
    // ビューがタップされたら実行
    @IBAction func tapView(sender: UITapGestureRecognizer) {
        // タップされた座標を調べる
        let tapPoint = sender.locationInView(view)
        
        // 指定した最終値になるようにアニメーションする
        UIView.animateWithDuration(1.0, // 1秒間で再生
            delay: 0, // 待ち時間なし
            options: UIViewAnimationOptions.CurveEaseInOut, //イーズインアウト
            animations: {
                // タップした座標に移動
                self.azarashi.center = tapPoint
            },
            completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

