//
//  ViewController.swift
//  animation_reverse_repeat
//
//  Created by yoshiyuki oshige on 2015/09/11.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        
        // アザラシをビューに追加する
        let azarashi = UIImageView(image: UIImage(named: "azarashi"))
        azarashi.center = CGPoint(x: 50, y: 150)
        self.view.addSubview(azarashi)

        // 画面を横に行ったり来たりする
        UIView.animateWithDuration(1.0, // 1秒間で再生
            delay: 0, // 待ち時間なし
            options: [UIViewAnimationOptions.CurveEaseInOut, // イーズインアウト
                UIViewAnimationOptions.Autoreverse, // 逆再生
                UIViewAnimationOptions.Repeat], // 繰り返し
            animations: {
                // 画面の右端へ移動する
               azarashi.center.x = self.view.frame.width - 50
            },
            completion: nil)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

