//
//  ViewController.swift
//  animation_transform_alpha
//
//  Created by yoshiyuki oshige on 2015/09/12.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBAction func tapView(sender: UITapGestureRecognizer) {
        // flowerを作る
        let flower = UIImageView(image: UIImage(named: "flower"))
        // 透明度を0にする
        flower.alpha = 0
        
        // 0.2 倍サイズにする
        let scaleTransform = CGAffineTransformMakeScale(0.2, 0.2)
        // -π/2 回転する
        let rotationTransform = CGAffineTransformMakeRotation(CGFloat(-M_PI_2))
        // トランスフォームを足し合わせる
        let transform = CGAffineTransformConcat(scaleTransform, rotationTransform)
        // flowerを変形させる
        flower.transform = transform

        // タップされた座標にflowerを追加する
        flower.center = sender.locationInView(self.view)
        self.view.addSubview(flower)
        
        // アニメーション
        UIView.animateWithDuration(1.0, // 1秒間で再生
            delay: 0, // 待ち時間なし
            options: UIViewAnimationOptions.CurveEaseInOut, //イーズインアウト
            animations: {
                // 透明度を1にする
                flower.alpha = 1.0
                // 変形を戻す
                flower.transform = CGAffineTransformIdentity
            },
            completion: nil)
    }
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

