//
//  ViewController.swift
//  uiImageView_animation_running
//
//  Created by yoshiyuki oshige on 2015/09/12.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // アニメーションのイメージビューをOutlet接続する
    @IBOutlet weak var boyView: UIImageView!

    // スライダとActions接続する
    @IBAction func runSpeed(sender: UISlider) {
        // 再生秒数をスライダで決める
        let sec = (1 - sender.value) * 3
        // 再生にかかる秒数を設定する
        boyView.animationDuration = NSTimeInterval(sec)

        // スライダの値が0のとき止める
        if sender.value == 0 {
            // アニメーションをストップする
            boyView.stopAnimating()
            // 立ち止まっているイメージに変える
            boyView.image = UIImage(named: "jogboy_0")
        } else {
            // アニメーションが止まっているならば再生する
            if !boyView.isAnimating() {
                // 再生するイメージの配列を設定する
                boyView.animationImages = jogboyImages()
                // 無限にループ再生する
                boyView.animationRepeatCount = 0
                // アニメーションをスタートする
                boyView.startAnimating()
            }
        }
        
    }
    
    // コマ送りのイメージの配列を作る
    func jogboyImages () -> Array<UIImage> {
        var theArray = Array<UIImage>()
        for num in 1...10 {
            // jogboy_1〜jogboy_10のイメージを作る
            let imageName = "jogboy_" + String(num)
            let image = UIImage(named: imageName)
            // 配列に追加する
            theArray.append(image!)
        }
        return theArray
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

