//
//  ViewController.swift
//  uiView_transitionFromView
//
//  Created by yoshiyuki oshige on 2015/09/13.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // スーパービューとOutlet接続する
    @IBOutlet weak var superView: UIView!
    
    // 現在のサブビュー
    var fromView: UIView!
    // 切り替えるビューの配列
    var viewList:Array<UIView>?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // セットアップ
        setUp()
    }
    
    // セットアップ
    func setUp() {
        // view1を作る
        let photo = UIImage(named: "eigakan")
        let view1 = UIImageView(image: photo)
        view1.bounds = CGRectMake(0, 0, 240, 180)
        
        // view2を作る
        let view2:UIView = UIView()
        view2.backgroundColor = UIColor.yellowColor()
        let label = UILabel(frame: CGRectMake(20, 50, 200, 44))
        label.numberOfLines = 2
        label.text = "view2です。\nこんにちは。"
        view2.addSubview(label)
        
        // 切り替えるビューの配列
        viewList = [view1,view2]
        
        // 最初にview1から表示する
        let localX = superView.frame.midX
        let localY = superView.frame.midY
        view1.center = CGPoint(x: localX, y: localY)
        superView.addSubview(view1)
        fromView = view1
    }
    
    // セグメンテッドコントロールでビューを選ぶ
    @IBAction func switchView(sender: UISegmentedControl) {
        // toViewを用意する
        let toView = viewList![sender.selectedSegmentIndex]
        toView.frame  = fromView.frame
        
        // 指定の映像効果でビューを入れ替える
        UIView.transitionFromView(
        fromView, // 開始ビュー
        toView: toView, // 終了ビュー
        duration: 1, // トランジションの秒数
        options: UIViewAnimationOptions.TransitionCurlUp, // 映像効果（カールアップ）
        completion:nil) // 完了後の動作
        
        // fromViewを更新する
        fromView = toView
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
}
