//
//  ViewController.swift
//  transitionWithView_image
//
//  Created by yoshiyuki oshige on 2015/10/27.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // 写真を表示するイメージビュー
    @IBOutlet weak var imageView: UIImageView!
    // セグメントコントロールで写真を選ぶ
    @IBAction func selectPhoto(sender: UISegmentedControl) {
        // 写真を選択する
        let photoList = ["IMG_4071.png","IMG_4184.png", "IMG_4807.png"]
        let fname = photoList[sender.selectedSegmentIndex]
        // 入れ替えるイメージを作る
        let newImage = UIImage(named: fname)
        
        // ビューの属性を映像効果を付けて更新する
        UIView.transitionWithView(imageView, // 更新するビュー
            duration: 1, // 1秒で切り替える
            options: UIViewAnimationOptions.TransitionCrossDissolve,
            animations: {
                // 写真のイメージを入れ替える
                self.imageView.image = newImage
            },
            completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

