//
//  ViewController.swift
//  transitionWithView_text
//
//  Created by yoshiyuki oshige on 2015/09/14.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var myText: UITextView!
    let text1 = "あいうえおかきくけこあいうえおかきくけこあいうえおかきくけこあいうえおかきくけこあいうえおかきくけこあいうえおかきくけこ"
    let text2 = "ABCDIFGHIJKLMNOPQRSTUVWXYZABCDIFGHIJKLMNOPQRSTUVWXYZABCDIFGHIJKLMNOPQRSTUVWXYZABCDIFGHIJKLMNOPQRSTUVWXYZ"
    
    
    @IBAction func changeText(sender: UISegmentedControl) {
        // テキストを入れ替える
        let textList = [text1, text2]
        let newText = textList[sender.selectedSegmentIndex]
        // 映像効果を付ける
        UIView.transitionWithView(myText,
            duration: 1,
            options: UIViewAnimationOptions.TransitionCrossDissolve,
            animations: {
                self.myText.text = newText
            },
            completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // 最初はtext1を表示しておく
        myText.text = text1
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

