//
//  ViewController.swift
//  blurEffect
//
//  Created by yoshiyuki oshige on 2015/10/12.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    // 写真
    @IBOutlet weak var myPhoto: UIImageView!
    // ブラー効果のビジュアルエフェクトビュー
    var blurEffectView:UIVisualEffectView!
    
    // ブラー効果のスイッチ
    @IBAction func blurSwitch(sender: UISwitch) {
        // エフェクトビューの表示と非表示を切り替える
        blurEffectView.hidden = !(sender.on)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        // ブラー効果を作る
        let blurEffect = UIBlurEffect(style: UIBlurEffectStyle.Light)
        // ビジュアルエフェクトビューを作る
        blurEffectView = UIVisualEffectView(effect: blurEffect)
        // 写真の上にビジュアルエフェクトビューを追加する
        view.insertSubview(blurEffectView, aboveSubview: myPhoto)
    }
    
    // myPhotoのframeが確定したところで実行する
    override func viewDidLayoutSubviews() {
        //　ビジュアルエフェクトビューの領域を写真と合わせる
        blurEffectView.frame = myPhoto.frame 
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

