//
//  ViewController.swift
//  addGestureRecognizer_tap
//
//  Created by yoshiyuki oshige on 2015/09/14.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()

        // hello()を実行するタップジェスチャーレコグナイザ
        let tapGesture = UITapGestureRecognizer(target: self, action: Selector("hello:"))
        // ビューを作る
        let myView = UIView(frame: CGRect(x: 100, y: 100, width: 80, height: 80))
        myView.backgroundColor = UIColor.greenColor()
        // tagに番号を付ける
        myView.tag = 1
        
        // ビューにタップジェスチャーレコグナイザを追加する
        myView.addGestureRecognizer(tapGesture)
        view.addSubview(myView)
    }
    
    // タップジェスチャーレコグナイザで実行するメソッド
    func hello(sender:UITapGestureRecognizer) {
        // tagの番号を調べる
        let tagNo = sender.view?.tag
        print("ハロー", tagNo!)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

