//
//  ViewController.swift
//  gestureRecognizer_rotation
//
//  Created by yoshiyuki oshige on 2015/10/23.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // トンボとOutlet接続する
    @IBOutlet weak var tombo: UIImageView!
    // 最後の回転角度
    var lastRotation:CGFloat = 0.0
    
    // ビューのローテーションでトンボを回す
    @IBAction func rotateTombo(sender: UIRotationGestureRecognizer) {
        
        switch sender.state {
        case .Began:
            // 前回の回転角度からはじめる
            sender.rotation = lastRotation
        case .Changed:
            // 回転角度にトンボを合わせる
            tombo.transform = CGAffineTransformMakeRotation(sender.rotation)
        case .Ended:
            // 回転終了時の回転角度を保存する
            lastRotation = sender.rotation
        default:
            break
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

