//
//  ViewController.swift
//  uiResponder_touches
//
//  Created by yoshiyuki oshige on 2015/09/16.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    // タッチ開始
    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        print(__FUNCTION__)
        // タッチされたビュー
        let target = touches.first?.view
        print(target!.frame)
    }
    
    // タッチ中
    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        print(__FUNCTION__)
        // タッチされている座標
        let loc = touches.first?.locationInView(view)
        print(loc!)
    }
    
    // タッチ終了
    override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
        print(__FUNCTION__)
    }
    
    // キャンセル
    override func touchesCancelled(touches: Set<UITouch>?, withEvent event: UIEvent?) {
        print(__FUNCTION__)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

