//
//  BoxView.swift
//  drawRect_rectangle
//
//  Created by yoshiyuki oshige on 2015/09/16.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class BoxView: UIView {
    // 初期値
    var fillColor = UIColor.yellowColor()
    var lineColor = UIColor.redColor()
    var lineWidth:CGFloat = 2.0

    
    // 描画する
    override func drawRect(rect: CGRect) {
        // サイズを決める
        var boxRect = bounds
        // 線の1/2幅だけ内側にする
        boxRect.insetInPlace(dx: lineWidth/2, dy: lineWidth/2)
        // パスを作る
        let drawPath = UIBezierPath(rect: boxRect)
        
        // 塗りの色を設定する
        fillColor.setFill()
        // 塗りつぶす
        drawPath.fill()
        
        // 線の色を設定する
        lineColor.setStroke()
        // 線幅
        drawPath.lineWidth = lineWidth
        // 線を描く
        drawPath.stroke()
    }
    
    
}
