//
//  ViewController.swift
//  imageContext_rectangle
//
//  Created by yoshiyuki oshige on 2015/09/16.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // 四角形の図形イメージを作る
    func makeBoxImage(witdh w:CGFloat, height h:CGFloat) -> UIImage {
        // イメージ処理の開始
        let size:CGSize = CGSize(width: w, height: h)
        UIGraphicsBeginImageContextWithOptions(size, false, 1.0)
        // コンテキスト
        let context = UIGraphicsGetCurrentContext()
        
        // サイズを決める
        var boxRect = CGRect(x: 0, y: 0, width: w, height: h)
        // 線の1/2幅だけ内側にする
        let lineWidth:CGFloat = 6.0
        boxRect.insetInPlace(dx: lineWidth/2, dy: lineWidth/2)
        // パスを作る
        let drawPath = UIBezierPath(rect: boxRect)
        
        // 塗り色
        CGContextSetRGBFillColor(context, 0.0, 1.0, 1.0, 1.0)
        // パスを塗る
        drawPath.fill()
        
        // 線の色
        CGContextSetRGBStrokeColor(context, 0.0, 0.0, 1.0, 1.0)
        // 線幅
        drawPath.lineWidth = lineWidth
        // パスを描く
        drawPath.stroke()
        
        // イメージコンテキストからUIImageを作る
        let image = UIGraphicsGetImageFromCurrentImageContext()
        // イメージ処理の終了
        UIGraphicsEndImageContext()

        return image
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        
        // 四角形のイメージを作る
        let boxImage = makeBoxImage(witdh: 200, height: 150)
        // イメージビューに設定する
        let boxView = UIImageView(image: boxImage)
        
        // 画面に表示する
        boxView.center = view.center
        view.addSubview(boxView)
        
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

