//
//  ViewController.swift
//  uiBezierPath_roundRect2
//
//  Created by yoshiyuki oshige on 2015/09/17.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    
    // 角丸四角形の図形イメージを作る
    func makeRoundRectImage(witdh w:CGFloat, height h:CGFloat) -> UIImage {
        // イメージ処理の開始
        let size:CGSize = CGSize(width: w, height: h)
        UIGraphicsBeginImageContextWithOptions(size, false, 1.0)
        // コンテキスト
        let context = UIGraphicsGetCurrentContext()
        
        // サイズを決める
        var drawRect = CGRect(x: 0, y: 0, width: w, height: h)
        // 線の幅だけ内側に描く
        let lineWidth:CGFloat = 8.0
        
        // 図形のパスを作る
        drawRect.insetInPlace(dx: lineWidth/2, dy: lineWidth/2)
        let drawPath = UIBezierPath(
            roundedRect: drawRect,
            byRoundingCorners: [.TopLeft, .BottomRight],
            cornerRadii: CGSize(width: 30, height: 30))
        
        // 塗り色
        CGContextSetRGBFillColor(context, 0.0, 1.0, 1.0, 1.0)
        // パスを塗る
        drawPath.fill()
        
        // 線の色
        CGContextSetRGBStrokeColor(context, 0.0, 0.0, 1.0, 1.0)
        // 線幅
        drawPath.lineWidth = lineWidth
        // パスを描く
        drawPath.stroke()
        
        // イメージコンテキストからUIImageを作る
        let image = UIGraphicsGetImageFromCurrentImageContext()
        // イメージ処理の終了
        UIGraphicsEndImageContext()
        
        return image
    }
    
    override func viewDidLoad() {
            super.viewDidLoad()
            
            // 図形のイメージを作る
            let drawImage = makeRoundRectImage(witdh: 200, height: 150)
            // イメージビューに設定する
            let drawView = UIImageView(image: drawImage)
            // 画面に表示する
            drawView.center = view.center
            view.addSubview(drawView)
    }
    
    override func didReceiveMemoryWarning() {
                super.didReceiveMemoryWarning()
                // Dispose of any resources that can be recreated.
    }
    
    
}
