//
//  ViewController.swift
//  uiBezierPath_fillRule
//
//  Created by yoshiyuki oshige on 2015/09/19.
//  Copyright © 2015年 yoshiyuki oshige. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    func drawPathImage() -> UIImage {
        // イメージ処理の開始
        let size:CGSize = view.bounds.size
        UIGraphicsBeginImageContextWithOptions(size, false, 1.0)
        
        // 四角形のパス
        let boxRect = CGRect(x: 80, y: 200, width: 150, height: 150)
        let boxPath = UIBezierPath(rect: boxRect)
        // 上の円のパス
        let ovalRect1 = CGRect(x: 50, y: 150, width: 150, height: 150)
        let ovalPath1 = UIBezierPath(ovalInRect: ovalRect1)
        // 下の円のパス
        let ovalRect2 = CGRect(x: 120, y: 250, width: 150, height: 150)
        let ovalPath2 = UIBezierPath(ovalInRect: ovalRect2)
        
        // パスを１つにまとめる
        let drawPath = UIBezierPath()
        drawPath.appendPath(boxPath)
        drawPath.appendPath(ovalPath1)
        drawPath.appendPath(ovalPath2)
        
        UIColor.redColor().setFill()
        // 重なりが奇数回の領域は塗らない
        drawPath.usesEvenOddFillRule = true
        drawPath.fill()

        // イメージコンテキストからUIImageを作る
        let image = UIGraphicsGetImageFromCurrentImageContext()
        // イメージ処理の終了
        UIGraphicsEndImageContext()
        return image
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // 図形のイメージを作る
        let drawImage = drawPathImage()
        // イメージビューに設定する
        let drawView = UIImageView(image: drawImage)
        // 画面に表示する
        view.addSubview(drawView)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

